
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

zeros:
              ld  b,32-16
1:            out (c),0
              djnz     1b
              dec d
              ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GENERAL INITIALIZIATION

INIT:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; screen init
;
              ld    hl,0101h	 ; COLOR ,1,1
              ld   (bakclr),hl

              xor a
              ld  (0F3DBh),a     ; key clik off
              ld  (0F3DEh),a     ; KEY OFF

              ld a,1
              call 05Fh          ; screen 1

              ld   a,(RG1SAV)
              or   2
              ld   b,a
              ld   c,1
              call wrtvdp        ; sprites 16x16 mag

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;    Tileset = 1 tile

              ld a,255
              ld bc,8
              push bc
              ld hl,01Ch*8
              call filvrm       ; FOG

              pop bc
              ld hl,08h*8
              call filvrm       ; WALLS

              ld   hl,PCT + 1
              ld   a,0x41
              call wrtvrm      ; color for tiles 8-15 - WALLS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Explosion        frames 0 - 3
;
              ld    hl,SPT
              call  setwrt   ; set sprites

              ld    hl,explosion
              ld    bc,4*32*256+98h
              otir

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; bullet           frame 4
;
              ld  a,011000000b
              out (0x98),a
              out (0x98),a

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MC & NPC sprites
              ld    hl,SPT+14*32
              call  setwrt   ; set sprites

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NPC sprites      frames 14 - 29
;
              ld    hl,npc_sprites
              ld    d,16

2:            ld    bc,4*256+98h
              otir
              ld    b,5
3:            dec hl
              outi
              jr nz,3B
              outi
              ld    b,4
3:            dec hl
              outi
              jr nz,3B
              outi
              outi

              call zeros
              jp  nz,2b

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MC sprites right,frames 30 - 37
;
              ld    hl,newmc
              ld    d,5;8

2:            ld    b,16
3:            ld    a,(hl)
              inc   hl

              ld    e,1
rot:          rrca
              rl    e
              jr    nc,rot

              out (c),e
              djnz 3b

              call zeros
              jp  nz,2b

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MC sprites left,frames 38-45
;
              ld    hl,SPT+38*32
              call  setwrt   ; set sprites

              ld    hl,newmc
              ld    d,5;8

2:            ld    b,16
              otir

              call zeros
              jp  nz,2b


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; RAM INIT

RINIT:
              xor  a
              ld   hl,endProgram
              ld   bc,endData-endProgram

FILLRAM:
        ; --- FILL RAM ---
		; --- A = Value to fill ---
		; --- HL = Origin ---
		; --- BC = Length ( -1 ) ---

              ld	(hl),a		    ; Write a
              ld	d,h				; d = h
              ld	e,l				; de = hl
              inc	de				; de = hl + 1
              ldir					; Copy
              ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite data
;
explosion:
              include "explosion.asm"
newmc:
              include "mc_sprites.asm"
npc_sprites:
              include "npc_sprites.asm"
